/******************************************************************************
 * The following code was generated by the mental mill(R)                     *
 * Fx_code_generator build 45261.7298 11 May 2009 nt-x86
 *                                                                            *
 * Copyright (c) 1986-2009 mental images GmbH, Berlin, Germany. *
 * All rights reserved.                                              *
 ******************************************************************************/


#ifdef _MAX_
string ParamID = "0x003";
#endif

bool bMill = true;
float Script : STANDARDSGLOBAL <
	string UIWidget = "none";
	string ScriptClass = "scene";
	string ScriptOutput = "color";
	string Script = "Technique=T0";
> = 0.8; // version #


#ifdef _MAX_ 
int texcoord1 : Texcoord
<
	int Texcoord = 0;
	int MapChannel = 1;
	string UIWidget = "None";
>;

int texcoord2 : Texcoord
<
	int Texcoord = 1;
	int MapChannel = 2;
	string UIWidget = "None";
>;

int texcoord3 : Texcoord
<
	int Texcoord = 2;
	int MapChannel = 3;
	string UIWidget = "None";
>;

int texcoord4 : Texcoord
<
	int Texcoord = 3;
	int MapChannel = 4;
	string UIWidget = "None";
>;

#endif

//
// The state structure is used internally within the fragment shader to
// commonly used values.
//
struct State
{
	float4 tex_coord[4];
	float3 position;
	float3 origin;
	float3 normal;
	float3 direction;
	float ray_length;
};

//
// Values for the light_type parameter of light shaders
//
#define LIGHT_POINT    0
#define LIGHT_SPOT     1
#define LIGHT_INFINITE 2
#define LIGHT_PLANAR   3

//
// The light iterator structure holds the return values resulting from
// evaluating a light.
//
#ifndef __LIGHT_ITERATOR_STRUCT
#define __LIGHT_ITERATOR_STRUCT
struct Light_iterator {
    float3 msl_point;
    float4 msl_contribution;
    float4 msl_raw_contribution;
    float  msl_dot_nl;
    float3 msl_direction;
    float  msl_distance;
    float4 msl_shadow;
    int    msl_count;
};
#endif // __LIGHT_ITERATOR_STRUCT

struct Ray {
    float3 msl_origin;
    float3 msl_direction;
};

Ray __Ray_ctor(float3 o, float3 d)
{
    Ray r;
    r.msl_origin = o;
    r.msl_direction = d;
    return r;
}

float2 __float2_ctor(float v)
{
	return v.xx;
}

float3 __float3_ctor(float v)
{
	return v.xxx;
}

float4 __float4_ctor(float v)
{
	return v.xxxx;
}

void __make_basis(const float3 n, const float3 u, const float3 v,
        out float3 t, out float3 b)
{
    b = normalize(cross(u,n));
    t = cross(n,b);
    if (dot(b,v) < 0.0)  b = -b;
}

float3 __perspective_divide(float4 pt)
{
    return pt.xyz/pt.w;
}

// 
// State dependant variable recalculation. 
// 
void __update_state_origin_or_position(inout State state) 
{ 
    state.direction = state.position - state.origin; 
    state.ray_length = length(state.direction); 
    state.direction = normalize(state.direction); 
} 

//
// The following are free parameters of the shader that should be set by the
// application at runtime.
//
float4 msl_mutliple_thread_proxy_checker_1_color1
<
	string UIName = "Color 1";
	float4 UIMin = float4(0.0, 0.0, 0.0, 0.0);
	float4 UIMax = float4(1.0, 1.0, 1.0, 1.0);
	float UIStep = 0.01;
	string UIWidget = "slider";
> = float4(0.800000, 0.800000, 0.800000, 1.0);
float4 msl_mutliple_thread_proxy_checker_1_color2
<
	string UIName = "Color 2";
	float4 UIMin = float4(0.0, 0.0, 0.0, 0.0);
	float4 UIMax = float4(1.0, 1.0, 1.0, 1.0);
	float UIStep = 0.01;
	string UIWidget = "slider";
> = float4(0.2, 0.2, 0.2, 1.0);
float msl_mutliple_thread_proxy_checker_1_checkerSize
<
	string UIName = "Checker Size";
	float UIMin = 0.0;
	float UIMax = 1.0;
	float UIStep = 0.01;
	string UIWidget = "slider";
> = 0.250000;


//
// The following are parameters representing non-varying state variables 
// referenced by the shader. These should be set by the application at runtime.
// Note that vector parameters should be provided in camera space.
//
float4x4 __object_to_ndc : WorldViewProjection
<
	string UIWidget = "none";
>;
float4x4 __world_to_object : WorldInverse
<
	string UIWidget = "none";
>;
float4x4 __object_to_world : World
<
	string UIWidget = "none";
>;
float4x4 __camera_to_world : ViewInverse
<
	string UIWidget = "none";
>;
//                                                   
// The following are parameters representing non-varying non-state variables      
// referenced by the shader. These should be set by the application at runtime.             
//                                                   
float4x4 __internal_to_light;
float4x4 __light_to_internal;



//
// The App2vert structure defines the vertex attributes used by the vertex
// shader. The application should supply a vertex stream containing these 
// elements.
//
struct App2vert
{
	float3 position : POSITION;
	float3 normal : NORMAL;
	float4 texcoord0 : TEXCOORD0;
	float4 texcoord1 : TEXCOORD1;
	float4 texcoord2 : TEXCOORD2;
	float4 texcoord3 : TEXCOORD3;
};

//
// The Vert2frag_out structure defines values output by the vertex shader.
//
struct Vert2frag_out
{
	float4 hpos : POSITION;
	float4 tex_coord[4] : TEXCOORD0;
	float3 position : TEXCOORD4;
	float3 normal : TEXCOORD5;
};

//
// The Vert2frag_in structure defines values used by the fragment shader.
//
struct Vert2frag_in
{
	float4 hpos : POSITION;
	float4 tex_coord[4] : TEXCOORD0;
	float3 position : TEXCOORD4;
	float3 normal : TEXCOORD5;
};

//
// This function is the main method of the vertex shader.
//
Vert2frag_out vertex_main(
	App2vert vs_in)
{
	Vert2frag_out vs_out;
	float4 position = float4(vs_in.position, 1);
	vs_out.hpos = mul(position, __object_to_ndc);
	vs_out.position = mul(position, __object_to_world).xyz;
	vs_out.normal = mul((float3x3)__world_to_object, vs_in.normal);
	vs_out.tex_coord[0] = vs_in.texcoord0;
	vs_out.tex_coord[1] = vs_in.texcoord1;
	vs_out.tex_coord[2] = vs_in.texcoord2;
	vs_out.tex_coord[3] = vs_in.texcoord3;
	return vs_out;
}

//
// The following functions are generated from the MetaSL implementation of
// the shaders that are part of the compiled shader graph.
//

void Generator_checker_main(
	inout State state,
	float4 msl_color1,
	float4 msl_color2,
	float msl_checkerSize,
	out float4 msl_result)
{
	{
		float2 msl_m = (fmod((abs((state.tex_coord)[0].xy)), msl_checkerSize)) / msl_checkerSize;
		msl_result = (float4((lerp((float4(msl_color1)), (float4(msl_color2)), (((msl_m.x < 0.5) == (msl_m.y < 0.5)) ? 1.0 : 0.0)))));
	}
}

//
// The following method is the root function of the shader graph
//
float4 mutliple_thread_proxy_checker_1_eval(State state)
{
	float4 msl_result;
	Generator_checker_main(state, msl_mutliple_thread_proxy_checker_1_color1, msl_mutliple_thread_proxy_checker_1_color2, msl_mutliple_thread_proxy_checker_1_checkerSize, msl_result);
	msl_result.a = 1.0;
	return msl_result;
}

//
// This function is the main method of the fragment shader. It initializes the
// values in the state structure that are used by nodes in the shader graph
// and produces the final result of the shader.
//
float4 fragment_main(
	Vert2frag_in fs_in) : COLOR
{
	State state;
	state.position = fs_in.position;
	state.normal = normalize(fs_in.normal);
	state.tex_coord = fs_in.tex_coord;
	state.origin = __camera_to_world[3];
	float3 eye_to_pos = state.position - state.origin;
	state.ray_length = length(eye_to_pos);
	state.direction = eye_to_pos/state.ray_length;
	return mutliple_thread_proxy_checker_1_eval(state);
}

//
// The following define the default technique and pass of the effect.
//
technique T0
{
	pass P0
	{
		VertexShader = compile vs_3_0 vertex_main();
		PixelShader  = compile ps_3_0 fragment_main();
	}
}

